// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ input.cpp ]					Auter : KENSUKE WATANABE
//													Data  : 2016/08/29
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2016/08/29
//
// ======== ======== ======== ======== ======== ======== ======== ========
#include "InputKeyboard.h"

//=============================================================================
// L[{[h̏
//=============================================================================
HRESULT CInputKeyboard::Init(HINSTANCE hInst, HWND hWnd)
{
	// ȅ(foCX̍쐬)
	CInput::Init(hInst);

	HRESULT hr;

	// foCXIuWFNg쐬
	hr = m_pDInput->CreateDevice(GUID_SysKeyboard, &m_pDIDevice, nullptr);
	if (FAILED(hr) || m_pDIDevice == nullptr)
	{
		MessageBox(hWnd, "L[{[h˂I", "xI", MB_ICONWARNING);
		return hr;
	}

	// f[^tH[}bgݒ
	hr = m_pDIDevice->SetDataFormat(&c_dfDIKeyboard);
	if (FAILED(hr))
	{
		MessageBox(hWnd, "L[{[h̃f[^tH[}bgݒł܂łB", "xI", MB_ICONWARNING);
		return hr;
	}

	// [hݒitHAOEhr[hj
	hr = m_pDIDevice->SetCooperativeLevel(hWnd, (DISCL_FOREGROUND | DISCL_NONEXCLUSIVE));
	if (FAILED(hr))
	{
		MessageBox(hWnd, "L[{[h̋[hݒł܂łB", "xI", MB_ICONWARNING);
		return hr;
	}

	// m_pDIDeviceANZXl(͐Jn)
	m_pDIDevice->Acquire();

	for (int i = 0; i < NUM_KEY_MAX; i++)
	{
		FlushTrigger(i);
	}

	return hr;
}

//=============================================================================
// L[{[hI
//=============================================================================
void CInputKeyboard::Uninit(void)
{
	if (m_pDIDevice)
	{// foCXIuWFNg̊J
		m_pDIDevice->Unacquire();

		m_pDIDevice->Release();
		m_pDIDevice = nullptr;
	}
}

//=============================================================================
// L[{[h̍XV
//=============================================================================
void CInputKeyboard::Update(void)
{
	HRESULT hr;
	BYTE aKeyState[NUM_KEY_MAX] = { 0 };

	if (!m_pDIDevice)
	{
		return;
	}

	// foCXf[^擾
	hr = m_pDIDevice->GetDeviceState(sizeof(aKeyState), aKeyState);
	if (SUCCEEDED(hr))
	{
		for (int nCntKey = 0; nCntKey < NUM_KEY_MAX; nCntKey++)
		{
			m_aStateTrigger[nCntKey] = (m_aState[nCntKey] ^ aKeyState[nCntKey]) & aKeyState[nCntKey];
			m_aStateRelease[nCntKey] = (m_aState[nCntKey] ^ aKeyState[nCntKey]) & ~aKeyState[nCntKey];
			m_aStateRepeat[nCntKey] = m_aStateTrigger[nCntKey];

			if (aKeyState[nCntKey])
			{
				m_aStateRepeatCnt[nCntKey]++;
				if (m_aStateRepeatCnt[nCntKey] >= COUNT_WAIT_REPEAT)
				{
					m_aStateRepeat[nCntKey] = aKeyState[nCntKey];
				}
			}
			else
			{
				m_aStateRepeatCnt[nCntKey] = 0;
				m_aStateRepeat[nCntKey] = 0;
			}

			m_aState[nCntKey] = aKeyState[nCntKey];
		}
	}
	else
	{
		m_pDIDevice->Acquire();
	}
}